<?php

namespace Import\ApiBundle\Services\Allegro;

use Import\ApiBundle\Entity\AllegroCategory;

class AllegroImportCategory extends AllegroMainService
{
    protected $type = 'AllegroImportCategory';

    public function __construct(\Symfony\Component\DependencyInjection\Container $Container)
    {
        parent::__construct($Container);
    }

    public function import()
    {
        echo "\r\nGet Category list from Allegro... ";
        $categoryList = $this->allegroClient->getCatsData();
        echo "DONE";
        echo "\r\nCategory list count = ".count($categoryList['cats-list']);

        $CategoryArray = $this->createArrayFromList($categoryList['cats-list']);
        $CategoryTree = $this->createTreeFromArray($CategoryArray);

        echo "\r\nSave... ";
        $this->printPercent_count = count($CategoryArray);
        $this->save($CategoryTree);

        $this->getDoctrine()->getManager()->flush();
        echo " DONE"."\r\n";

//        echo "\r\n";
//        $this->echoTreeCategory($CategoryTree,0);

        return array('count' => count($CategoryArray));
    }

    protected function save($tree)
    {
        $this->printPercent();
        foreach($tree[0]['children'] as $child)
        {
//            if($child['id'] == 20782)   //Nieruchomosci
//            if($child['id'] == 2)       //Komputery
//            if($child['id'] == 3)       //Motoryzacja
            if($child['id'] == 20782 || $child['id'] == 2 || $child['id'] == 3 || $child['id'] == 4)       //Telefony i akcesoria
            {
                $this->printPercent();
                $child['Parent'] = null;
                $root = $this->getDoctrine()->getRepository('ImportApiBundle:AllegroCategory')->add($child);
                $this->saveTree($child['children'],$root,0);

                $this->getDoctrine()->getManager()->flush();
                $this->getDoctrine()->getManager()->clear();
            }
        }
    }

    protected function saveTree($children,$root,$level)
    {
        if(count($children) > 0)
        {
            $level++;
            foreach($children as $child)
            {
                $this->printPercent();
                $child['Parent'] = $root;
                $newRoot = $this->getDoctrine()->getRepository('ImportApiBundle:AllegroCategory')->add($child);
                $this->saveTree($child['children'],$newRoot,$level);
            }
        }

    }

    private function createArrayFromList($list)
    {
        echo "\r\nCreare array list... ";
        $arrayList = array(array('id' => 0,'title' => 'ROOT','parent' => NULL,'position' => 1,'children' => array(),'childrenIds' => array(),'parentIds' => array()));
        foreach($list as $cat)
        {
            $arrayList[$cat->{'cat-id'}] = $this->createNewCat($cat);
        }
        echo "Done";

        return $arrayList;
    }

    private function createTreeFromArray($arrayList)
    {
        echo "\r\nPrepare tmp list... ";
        $newList = array();
        foreach ($arrayList as $a)
        {
            $newList[$a['parent']][] = $a;
        }
        echo "Done";

        echo "\r\nCreate Tree... ";
        $tree = $this->createTree($newList, array($arrayList[0]));
        echo "Done";

        return $tree;
    }

    private function createNewCat($cat)
    {
        return array(
            'id' => $cat->{'cat-id'},
            'title' => $cat->{'cat-name'},
            'parent' => $cat->{'cat-parent'},
            'position' => $cat->{'cat-position'},
            'children' => array(),
            'childrenIds' => array(),
            'parentIds' => array()
        );
    }

    private function createTree(&$list, $parent)
    {
        $tree = array();
        foreach ($parent as $k=>$l)
        {
            if(isset($list[$l['id']]))
            {
                $l['children'] = $this->createTree($list, $list[$l['id']]);
            }
            $tree[] = $l;
        }
        return $tree;
    }

    private function echoTreeCategory($CategoryTree,$level)
    {
        foreach($CategoryTree as $category)
        {
            for($i=0;$i<$level;$i++) echo ' ';
            echo "id=".$category['id'].",title=".$category['title'].",position=".$category['position']."\r\n";
            if(count($category['children']) > 0)
            {
                $level++;
                $this->echoTreeCategory($category['children'],$level);
            }
        }
    }
}